/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.sso.admin;

import com.vmware.vim.binding.sso.PrincipalId;
import com.vmware.vim.binding.sso.admin.GroupDetails;
import com.vmware.vim.binding.sso.admin.PersonDetails;
import com.vmware.vim.binding.sso.admin.SolutionDetails;
import com.vmware.vim.binding.sso.version.version1;
import com.vmware.vim.binding.sso.version.version2;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;

@fullyQualifiedVmodlName(value="sso.admin.PrincipalManagementService")
@managed
@versionClass(value=version1.class)
@wsdlName(value="SsoAdminPrincipalManagementService")
public interface PrincipalManagementService
extends ManagedObject {
    @versionClass(value=version1.class)
    @wsdlName(value="CreateLocalPersonUser")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoAdminFaultPasswordPolicyViolationFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void createLocalPersonUser(@name(value="userName") @versionClass(value=version1.class) String var1, @name(value="userDetails") @versionClass(value=version1.class) PersonDetails var2, @name(value="password") @versionClass(value=version1.class) @secret String var3, Future<PrincipalId> var4);

    @versionClass(value=version1.class)
    @wsdlName(value="CreateLocalSolutionUser")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoAdminFaultDuplicateSolutionCertificateFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void createLocalSolutionUser(@name(value="userName") @versionClass(value=version1.class) String var1, @name(value="userDetails") @versionClass(value=version1.class) SolutionDetails var2, @name(value="external") @versionClass(value=version2.class) @optional Boolean var3, Future<PrincipalId> var4);

    @versionClass(value=version1.class)
    @wsdlName(value="CreateLocalGroup")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void createLocalGroup(@name(value="groupName") @versionClass(value=version1.class) String var1, @name(value="groupDetails") @versionClass(value=version1.class) GroupDetails var2, Future<PrincipalId> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="DeleteLocalPrincipal")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void deleteLocalPrincipal(@name(value="principalName") @versionClass(value=version1.class) String var1, Future<Void> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="RemoveFromLocalGroup")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void removeFromLocalGroup(@name(value="principalId") @versionClass(value=version1.class) PrincipalId var1, @name(value="groupName") @versionClass(value=version1.class) String var2, Future<Boolean> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="RemovePrincipalsFromLocalGroup")
    @privilege(value="Sso.AdminServer.Administer")
    @list
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void removePrincipalsFromLocalGroup(@name(value="principalsIds") @versionClass(value=version1.class) @list PrincipalId[] var1, @name(value="groupName") @versionClass(value=version1.class) String var2, @list Future<boolean[]> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="AddUserToLocalGroup")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void addUserToLocalGroup(@name(value="userId") @versionClass(value=version1.class) PrincipalId var1, @name(value="groupName") @versionClass(value=version1.class) String var2, Future<Boolean> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="AddUsersToLocalGroup")
    @privilege(value="Sso.AdminServer.Administer")
    @list
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void addUsersToLocalGroup(@name(value="userIds") @versionClass(value=version1.class) @list PrincipalId[] var1, @name(value="groupName") @versionClass(value=version1.class) String var2, @list Future<boolean[]> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="AddGroupToLocalGroup")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoAdminFaultGroupCyclicDependencyFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void addGroupToLocalGroup(@name(value="groupId") @versionClass(value=version1.class) PrincipalId var1, @name(value="groupName") @versionClass(value=version1.class) String var2, Future<Boolean> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="AddGroupsToLocalGroup")
    @privilege(value="Sso.AdminServer.Administer")
    @list
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoAdminFaultGroupCyclicDependencyFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void addGroupsToLocalGroup(@name(value="groupIds") @versionClass(value=version1.class) @list PrincipalId[] var1, @name(value="groupName") @versionClass(value=version1.class) String var2, @list Future<boolean[]> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateLocalPersonUserDetails")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void updateLocalPersonUserDetails(@name(value="userName") @versionClass(value=version1.class) String var1, @name(value="userDetails") @versionClass(value=version1.class) PersonDetails var2, Future<PrincipalId> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="ResetLocalPersonUserPassword")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoAdminFaultPasswordPolicyViolationFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void resetLocalPersonUserPassword(@name(value="userName") @versionClass(value=version1.class) String var1, @name(value="newPassword") @versionClass(value=version1.class) @secret String var2, Future<Void> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateLocalSolutionUserDetails")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void updateLocalSolutionUserDetails(@name(value="userName") @versionClass(value=version1.class) String var1, @name(value="userDetails") @versionClass(value=version1.class) SolutionDetails var2, Future<PrincipalId> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateLocalGroupDetails")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void updateLocalGroupDetails(@name(value="groupName") @versionClass(value=version1.class) String var1, @name(value="groupDetails") @versionClass(value=version1.class) GroupDetails var2, Future<PrincipalId> var3);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateSelfLocalPersonUserDetails")
    @privilege(value="Sso.Self.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultInvalidCredentials"})
    public void updateSelfLocalPersonUserDetails(@name(value="userDetails") @versionClass(value=version1.class) PersonDetails var1, Future<PrincipalId> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="DeleteSelfSolutionUser")
    @privilege(value="Sso.Self.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultInvalidCredentials"})
    public void deleteSelfSolutionUser(Future<Void> var1);

    @versionClass(value=version1.class)
    @wsdlName(value="ResetSelfLocalPersonUserPassword")
    @privilege(value="Sso.Self.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoAdminFaultPasswordPolicyViolationFault", "SsoFaultNotAuthenticated", "SsoFaultInvalidCredentials"})
    public void resetSelfLocalPersonUserPassword(@name(value="newPassword") @versionClass(value=version1.class) @secret String var1, Future<Void> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="ResetLocalUserPassword")
    @privilege(value="dynamic")
    @faults(value={"InvalidRequest", "SsoFaultInvalidPrincipalFault", "SsoAdminFaultPasswordPolicyViolationFault"})
    public void resetLocalUserPassword(@name(value="username") @versionClass(value=version1.class) String var1, @name(value="currentPassword") @versionClass(value=version1.class) @secret String var2, @name(value="newPassword") @versionClass(value=version1.class) @secret String var3, Future<Void> var4);

    @versionClass(value=version1.class)
    @wsdlName(value="UpdateSelfLocalSolutionUserDetails")
    @privilege(value="Sso.Self.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultInvalidCredentials"})
    public void updateSelfLocalSolutionUserDetails(@name(value="userDetails") @versionClass(value=version1.class) SolutionDetails var1, Future<PrincipalId> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="UnlockUserAccount")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void unlockUserAccount(@name(value="userId") @versionClass(value=version1.class) PrincipalId var1, Future<Boolean> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="EnableUserAccount")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void enableUserAccount(@name(value="userId") @versionClass(value=version1.class) PrincipalId var1, Future<Boolean> var2);

    @versionClass(value=version1.class)
    @wsdlName(value="DisableUserAccount")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void disableUserAccount(@name(value="userId") @versionClass(value=version1.class) PrincipalId var1, Future<Boolean> var2);

    @versionClass(value=version2.class)
    @wsdlName(value="GetDaysRemainingUntilPasswordExpiration")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void getDaysRemainingUntilPasswordExpiration(@name(value="userId") @versionClass(value=version2.class) PrincipalId var1, Future<Integer> var2);

    @versionClass(value=version2.class)
    @wsdlName(value="GetDaysRemainingUntilSelfPasswordExpiration")
    @privilege(value="Sso.Self.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultInvalidCredentials"})
    public void getDaysRemainingUntilSelfPasswordExpiration(Future<Integer> var1);

    @versionClass(value=version2.class)
    @wsdlName(value="RegisterExternalUser")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void registerExternalUser(@name(value="externalUserId") @versionClass(value=version2.class) PrincipalId var1, Future<Boolean> var2);

    @versionClass(value=version2.class)
    @wsdlName(value="RemoveExternalUser")
    @privilege(value="Sso.AdminServer.Administer")
    @faults(value={"SsoFaultInvalidPrincipalFault", "SsoFaultNotAuthenticated", "SsoFaultNoPermission", "SsoFaultInvalidCredentials"})
    public void removeExternalUser(@name(value="externalUserId") @versionClass(value=version2.class) PrincipalId var1, Future<Boolean> var2);
}

