#!/bin/bash
#
# Copyright 2012 VMware, Inc. All rights reserved.
#

case $1 in
    start | stop | restart ) service vmware-rbd-watchdog $1
    ;;

    setstartuptype)
        case "$2" in
            automatic)
                chkconfig vmware-rbd-watchdog on
            ;;
            manual)
                chkconfig vmware-rbd-watchdog off
            ;;
        esac
        ;;

    getstartuptype)
        startup_type=`chkconfig vmware-rbd-watchdog | awk '{printf "%s",$NF}'`
        case $startup_type in
            on)
                echo "AUTOMATIC"
            ;;
            off)
                echo "MANUAL"
            ;;
        esac
       ;;

    status )
        service vmware-rbd-watchdog status > /dev/null 2>&1
        if [ $? -eq 0 ]; then
            echo "RUNNING"
        else
            echo "STOPPED"
        fi
    ;;
    *)
        echo "ERROR: usage: `basename $0` {start|stop|status|restart|setstartuptype automatic|setstartuptype manual|getstartuptype}"
    ;;
esac
