__copyright__ = 'VMware, Inc 2015'
'''ImageBuilder SCA config script'''
# https://opengrok.eng.vmware.com/source/xref/vsphere-2015.perforce.1666/bora/cis/services/sca/src/main/resources/serviceconfig.py

import os
import sys
import logging
from serviceconfig import ServiceConfig, PLAT_IND_CIS_HOME, ConfigError, _scm_load_properties

IMAGEBUILDER_LOGLEVEL_KEY = 'loglevel'

#__python2_hack__
IMAGEBUILDER_LOGLEVEL_VALUES = getattr(logging, '_levelNames', getattr(logging, '_nameToLevel',{})).keys()

INVALID_ARGUMENT = 'cis.error.invalidValue'

class ImageBuilderConfig(ServiceConfig):
    def _validate(self):
        ''' Provide additional validation of potential update before they are set
        '''
        try:
            props = _scm_load_properties(sys.stdin.buffer)
        except:
            props = _scm_load_properties(sys.stdin)
        logging.info('Input properties = %r\n' % props)
        for prop_key, prop_value in props.items():
            if prop_key == IMAGEBUILDER_LOGLEVEL_KEY and prop_value.upper() not in IMAGEBUILDER_LOGLEVEL_VALUES:
                ConfigError(INVALID_ARGUMENT, prop_key, 'The provided loglevel is not supported.').fatal()
        logging.info("Loglevel validation successful.")

    def _notify(self):
        ''' Called after the new values are set to services can act accordingly and read the new values
        '''
        pass

cfg_path = '%s-imagebuilder' % os.environ['VMWARE_CFG_DIR']
sca_config_path = os.path.join(cfg_path, 'sca-config')
prop_path = os.path.join(sca_config_path, 'imagebuilder-config.props')
attr_path = os.path.join(sca_config_path, 'imagebuilder-config.attrs')
ImageBuilderConfig(prop_path, attr_path)
