# serviceconfig file for VCDE transfer-svc
# When placed in /usr/lib/vmware-sca/scripts/configuration
# or %VMWARE_CIS_HOME%\sca\scripts\configuration (for windows),
# VCDS can register this file with SCM, and then proceed to use SCM
# to read/write config values.
from serviceconfig import ServiceConfig, PLAT_IND_CIS_HOME
import os

__copyright__ = 'Copyright (c) 2013-2014 VMware, Inc. All rights reserved. VMware Confidential'


def is_windows():
    return os.name != 'posix'

if is_windows():
    vdcs_cfg_path = os.path.join(os.environ['VMWARE_CFG_DIR'], 'content-library')
else:
    vdcs_cfg_path = "%s-content-library" % os.environ['VMWARE_CFG_DIR']

ServiceConfig('%s/config/ts-config.properties' % vdcs_cfg_path)
