#!/bin/bash
#
# Copyright 2015 VMware, Inc. All rights reserved.
#

case $1 in
    start | stop | restart ) /opt/likewise/bin/lwsm $1 vmcam
    ;;

    setstartuptype)
        case "$2" in
            automatic)
                chkconfig vmcam on

            ;;
            manual)
                chkconfig vmcam off

            ;;
        esac
        ;;

    getstartuptype)
       startup_type=`chkconfig vmcam | sed -e 's/  */ /g' | cut -d' ' -f2`
        case $startup_type in
            on)
                echo "AUTOMATIC"
            ;;
            off)
                echo "MANUAL"
            ;;
        esac
       ;;

    status )
        service_status=`/opt/likewise/bin/lwsm status vmcam|awk '{print $1;}'`
        case $service_status in
            running)
                echo "RUNNING"
            ;;
            *)
                echo "STOPPED"
            ;;
        esac
        ;;
    *)
        echo "ERROR: usage: `basename $0` {start|stop|status|restart|setstartuptype automatic|setstartuptype manual|getstartuptype}"
        ;;
esac
