#!/bin/bash
#
# Copyright 2012 VMware, Inc.  All rights reserved.
#
# vmware-netdumper.sh     Start/Stop/Get Status/Restart the VMware ESXi dump collector service
#

# Note: There is no concept of enabling/disabling a service, so 'start'/'stop' have been
# overloaded to mean 'enable and start'/'stop and disable' respectively.

case $1 in
    start )
        chkconfig vmware-netdumper on
        service vmware-netdumper start
    ;;

    stop )
        chkconfig vmware-netdumper off
        service vmware-netdumper stop
    ;;

    restart )
        service vmware-netdumper restart
    ;;
    setstartuptype )
        case $2 in
            automatic )
                chkconfig vmware-netdumper on
            ;;
            manual )
                chkconfig vmware-netdumper off
            ;;
        esac
        ;;

    getstartuptype )
        startup_type=`chkconfig vmware-netdumper | sed -e 's/  */ /g' | cut -d' ' -f2`
        case $startup_type in
            on )
                echo "AUTOMATIC"
            ;;
            off )
                echo "MANUAL"
            ;;
        esac
        ;;
    status )
        service vmware-netdumper status > /dev/null 2>&1
        if [ $? -eq 0 ]; then
            echo "RUNNING"
        else
            echo "STOPPED"
        fi
    ;;
    *)
        echo "Usage: `basename "$0"` {start|stop|status|restart|setstartuptype automatic|setstartuptype manual|getstartuptype}"
    ;;
esac
