#!/bin/bash
#
#  Copyright 2013 VMware, Inc.  All rights reserved.
#
# vmware-perfcharts.sh     Start/Stop Performance Charts service
#
#
case $1 in
   start | stop | restart )
      service vmware-perfcharts $1
      ;;

   status )
      service vmware-perfcharts status > /dev/null 2>&1
      if [ $? -eq 0 ]; then
         echo "RUNNING"
      else
         echo "STOPPED"
      fi
      ;;

   * )
      echo "Usage: `basename "$0"` {start|stop|status|restart}"
      ;;
esac
