#!/bin/bash
#
# Copyright 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
#
# vmware-vsan-health-sca.sh     Start/Stop/Get Status/Restart the VMware vSphere vSAN Health Check Service
#
case $1 in
  start | stop | restart )
      /etc/init.d/vmware-vsan-health $1
   ;;
  status )
      /etc/init.d/vmware-vsan-health status > /dev/null 2>&1
      if [ $? -eq 0 ]; then
         echo "RUNNING"
      else
         echo "STOPPED"
      fi
   ;;
  *)
   echo "ERROR: usage: `basename "$0"` {start|stop|status|restart}"
   ;;
esac
