#!/usr/bin/env bash
# Copyright (c) 2022-2024 Broadcom. All Rights Reserved.
# Broadcom Confidential. The term "Broadcom" refers to Broadcom Inc.
# and/or its subsidiaries.
$VMWARE_CLOUDVM_RAM_SIZE -J vmware-sps -O $VMWARE_DATA_DIR/vmware-vmon/sps.start.cmd
/usr/bin/sudo -u sps /usr/lib/vmware-vmafd/bin/vecs-cli entry list --store sms &> /dev/null
# Grant "sps" user read, write permission for SMS store
if [[ "$?" -ne 0 ]]; then
    error_sps_sms=$( /usr/bin/sudo -u sps /usr/lib/vmware-vmafd/bin/vecs-cli entry list --store sms 2>&1)
    if [[ $error_sps_sms != *"ERROR_OBJECT_NOT_FOUND"* ]]; then
        /usr/lib/vmware-vmafd/bin/vecs-cli store permission --user sps --name sms --grant read
        /usr/lib/vmware-vmafd/bin/vecs-cli store permission --user sps --name sms --grant write
    fi
fi
/usr/bin/sudo -u vpxd /usr/lib/vmware-vmafd/bin/vecs-cli entry list --store sms &> /dev/null
if [[ "$?" -ne 0 ]]; then
    error_vpxd_sms=$( /usr/bin/sudo -u vpxd /usr/lib/vmware-vmafd/bin/vecs-cli entry list --store sms 2>&1)
    if [[ $error_vpxd_sms != *"ERROR_OBJECT_NOT_FOUND"* ]]; then
        /usr/lib/vmware-vmafd/bin/vecs-cli store permission --user vpxd --name sms --grant read
        /usr/lib/vmware-vmafd/bin/vecs-cli store permission --user vpxd --name sms --grant write
    fi
fi
# Grant "sps" user read, write permission for TRUSTED_ROOTS store.
/usr/bin/sudo -u sps /usr/lib/vmware-vmafd/bin/vecs-cli entry list --store trusted_roots &> /dev/null
if [[ "$?" -ne 0 ]]; then
    /usr/lib/vmware-vmafd/bin/vecs-cli store permission --user sps --name trusted_roots --grant read
fi
/usr/lib/vmware-vmafd/bin/vecs-cli store permission --user sps --name trusted_roots --grant write
# Grant "sps" user read, write permission for vpxd-extension store.
/usr/bin/sudo -u sps /usr/lib/vmware-vmafd/bin/vecs-cli entry list --store vpxd-extension &> /dev/null
if [[ "$?" -ne 0 ]]; then
    /usr/lib/vmware-vmafd/bin/vecs-cli store permission --user sps --name vpxd-extension --grant read
fi
/usr/lib/vmware-vmafd/bin/vecs-cli store permission --user sps --name vpxd-extension --grant write
# Grant access to sps user for log directory if the dir exists (needed for upgrade)
LOG_DIRECTORY="/var/log/vmware/vmware-sps"
if [ -d "$LOG_DIRECTORY" ]; then
  chown -R sps:root /var/log/vmware/vmware-sps
fi
# Grant access to sps user for conf directory if the dir exists (needed for upgrade)
CONF_DIRECTORY="/usr/lib/vmware-vpx/sps/conf"
if [ -d "$CONF_DIRECTORY" ]; then
  chown -R sps:root /usr/lib/vmware-vpx/sps/conf
  chmod -R 0755 /usr/lib/vmware-vpx/sps/conf
fi
# Grant access to sps user for static content directory if the dir exists (needed for upgrade)
STATIC_CONTENT="/usr/lib/vmware-vpx/sps/resources/static-content/sms"
if [ -d "$STATIC_CONTENT" ]; then
  chown -R sps:root /usr/lib/vmware-vpx/sps/resources/static-content/sms
fi
# Grant access to sps user for vapi_metadata directory if the dir exists (needed for upgrade)
VAPI_DIRECTORY="/usr/lib/vmware-vpx/sps/vapi_metadata"
if [ -d "$VAPI_DIRECTORY" ]; then
  chown -R sps:root /usr/lib/vmware-vpx/sps/vapi_metadata
fi

/usr/bin/python /usr/lib/vmware-vpx/sps/scripts/sps_prestart.py
